DROP TABLE IF EXISTS `site_plugin_redirects`;
CREATE TABLE `site_plugin_redirects` (
  `redirect_id` int(11) NOT NULL AUTO_INCREMENT,
  `redirect_type` int(2) NOT NULL,
  `redirect_source` text NOT NULL,
  `redirect_code` varchar(20) NOT NULL,
  `redirect_destination_type` int(1) NOT NULL,
  `redirect_destination` text NOT NULL,
  `redirect_destination_module` int(11) NOT NULL,
  `redirect_destination_global` int(11) NOT NULL,
  `redirect_clicks` int(11) NOT NULL,
  `redirect_date` int(11) NOT NULL,
  `redirect_domain` int(11) NOT NULL,
  PRIMARY KEY (`redirect_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_redirects_domains`;
CREATE TABLE `site_plugin_redirects_domains` (
  `domain_id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_type` int(2) NOT NULL,
  `domain_name` varchar(255) NOT NULL,
  `domain_main` int(1) NOT NULL,
  `domain_clicks` int(11) NOT NULL,
  PRIMARY KEY (`domain_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_redirects_pages`;
CREATE TABLE `site_plugin_redirects_pages` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(255) NOT NULL,
  `item_status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_redirects_pages_lang`;
CREATE TABLE `site_plugin_redirects_pages_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_details` longtext NOT NULL,
  `seo_title` text NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  `item_subtitle` text NOT NULL,
  KEY `item_id` (`item_id`),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_redirects_stats`;
CREATE TABLE `site_plugin_redirects_stats` (
  `stat_id` int(11) NOT NULL AUTO_INCREMENT,
  `stat_redirect` int(11) NOT NULL,
  `stat_date` int(11) NOT NULL,
  `stat_from` text NOT NULL,
  `stat_ip` varchar(30) NOT NULL,
  `stat_hostname` varchar(255) NOT NULL,
  PRIMARY KEY (`stat_id`),
  KEY `stat_redirect` (`stat_redirect`,`stat_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `site_plugin_redirects_pages` (`item_id`, `item_code`) VALUES
(3, '404'),
(4, '403');

INSERT INTO `site_plugin_redirects_pages_lang` (`item_id`, `lang_id`, `item_title`, `item_details`, `seo_title`, `seo_desc`, `seo_meta`, `seo_conv_head`, `seo_conv_body`) VALUES
(3, 1, 'Page not found', '<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<div>[errortitle=404]ERROR[/errortitle]\r\n<h2>It looks like the page doesn&#39;t exist or some other error occured.<br />\r\n<strong>Go&nbsp;to our <a href="{PUB:HOME_LINK}">home page</a> or back to the&nbsp;<a href="javascript:goBack();">previous page</a>.</strong></h2>\r\n</div>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', 'Page not found', '', '', '', ''),
(4, 1, 'Page forbidden', '<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<div>[errortitle=403]ERROR[/errortitle]\r\n<h2>It looks like the page doesn&#39;t exist or some other error occured.<br />\r\n<strong>Go&nbsp;to our <a href="{PUB:HOME_LINK}">home page</a> or back to the&nbsp;<a href="javascript:goBack();">previous page</a>.</strong></h2>\r\n</div>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', 'Page forbidden', '', '', '', '');